<?php 
defined('BASEPATH') OR exit('This page is not found');

class Forum_model extends CI_Model
{
    /*
    ======================================================
    * Creating of data
    ======================================================
    */

    //* Create new category
    public function createNewForumCategory($data)
    {
        $this->db->insert('zd_forums_cats', $data);
        return TRUE;
    }

    //* Create new topic
    public function createNewTopic($data)
    {
        $this->db->insert('zd_forums', $data);
        return $this->db->insert_id();
    }

    //* Create new forum reply
    public function createNewForumReply($data)
    {
        $this->db->insert('zd_forum_reply', $data);
        return $this->db->insert_id();
    }

    /*
    ======================================================
    * Creating of data ends
    ======================================================
    */

    /*
    ======================================================
    * Reading of data
    ======================================================
    */

    //* GEt forum cats in admin
    public function  getForumCatAdmin()
    {
        $this->db->order_by('fcat_id', 'DESC');
        $query = $this->db->get('zd_forums_cats');
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return FALSE;
        }
    }

    //* Get forum boards
    public function getForumBoards()
    {
        $this->db->where('fcat_status', 1);
        $this->db->order_by('fcat_id');
        $query = $this->db->get('zd_forums_cats');
        if($query->num_rows() > 0)
        {
            $res = array();
            foreach($query->result() as $post)
            {
                $res[$post->fcat_id] = $post;
                $res[$post->fcat_id]->forums = $this->getBoardForumZone($post->fcat_id);
            }
            return $res;
        }
        else
        {
            return FALSE;
        }
    }

    //* Get forum boards
    public function getBoardForumZone($id)
    {
        $this->db->join('zd_users', 'zd_users.user_id = zd_forums.forum_user_id', 'left');
        $this->db->where('zd_forums.forum_cat_id', $id);
        $this->db->order_by('zd_forums.forum_id', 'DESC');
        $this->db->limit(6);
        $query = $this->db->get('zd_forums');
        if($query->num_rows() > 0)
        {
            $res = array();
            foreach($query->result() as $board)
            {
                $res[$board->forum_id] = $board;
                $res[$board->forum_id]->last_reply = $this->getForumLastReplyBoard($board->forum_id);
                $res[$board->forum_id]->total_reply = $this->getForumReplyTotalBoard($board->forum_id);
            }
            return $res;
        }
        else
        {
            return FALSE;
        }
    }

    //* Get last forum reply board
    public function getForumLastReplyBoard($id)
    {
        $this->db->where('zd_forum_reply.fr_forum_id', $id);
        $this->db->join('zd_users', 'zd_users.user_id = zd_forum_reply.fr_user_id', 'left');
        $this->db->order_by('zd_forum_reply.fr_id', 'DESC');
        $query = $this->db->get('zd_forum_reply');
        if($query->num_rows() > 0)
        {
            return $query->row(0);
        }
        else
        {
            return FALSE;
        }
    }

    //* Get last created forum
    public function getLastCreatedForum($id)
    {
        $this->db->where('forum_id', $id);
        $query = $this->db->get('zd_forums');
        return $query->row(5)->forum_slug;
    }

    //* Get single forum post
    public function getSinglePost($slug)
    {
        $this->db->where('forum_slug', $slug);
        $this->db->join('zd_users', 'zd_users.user_id = zd_forums.forum_user_id', 'left');
        $this->db->join('zd_forums_cats', 'zd_forums_cats.fcat_id = zd_forums.forum_cat_id', 'left');
        $query = $this->db->get('zd_forums');
        if($query->num_rows() > 0)
        {
            return $query->row();
        }
        else
        {
            return FALSE;
        }
    }

    //* Get last forum reply
    public function getForumLastReply($last_id)
    {
        $this->db->where('fr_id', $last_id);
        $this->db->join('zd_users', 'zd_users.user_id = zd_forum_reply.fr_user_id', 'left');
        $query = $this->db->get('zd_forum_reply');
        if($query->num_rows() > 0)
        return $query->row(0);
    }

    //* Get forum replies
    public function getForumReply($id, $offset)
    {
        $this->db->join('zd_users', 'zd_users.user_id = zd_forum_reply.fr_user_id', 'left');
        $this->db->where('zd_forum_reply.fr_forum_id', $id);
        $this->db->order_by('zd_forum_reply.fr_id', 'ASC');
        $this->db->limit(8, $offset);
        $query = $this->db->get('zd_forum_reply');
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return FALSE;
        }
    }

    //* Get forum reply contents
    public function getReplyContents($id)
    {
        $this->db->where('	fr_id', $id);
        $query = $this->db->get('zd_forum_reply');
        return $query->row(0);
    }

    //* GEt forum replying to
    public function getForumReplyTo($id)
    {
        $this->db->where('	forum_id', $id);
        $this->db->join('zd_users', 'zd_users.user_id = zd_forums.forum_user_id', 'left');
        $query = $this->db->get('zd_forums');
        return $query->row(0);
    }

    //* Get forum commenters
    public function getForumCommenters($id,$my_id, $a_id)
    {
        $this->db->join('zd_users', 'zd_users.user_id = zd_forum_reply.fr_user_id', 'left');
        $this->db->where('zd_forum_reply.fr_forum_id', $id);
        $this->db->where('zd_forum_reply.fr_user_id !=', $my_id);
        $this->db->where('zd_forum_reply.fr_user_id !=', $a_id);
        $this->db->group_by('zd_forum_reply.fr_user_id');
        $query = $this->db->get('zd_forum_reply');
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return FALSE;
        }
    }

    //* Get forum cats by slug
    public function getForumCatBySlug($slug)
    {
        $this->db->where('fcat_slug', $slug);
        $query = $this->db->get('zd_forums_cats');
        if($query->num_rows() > 0)
        {
            return $query->row(0);
        }
        else
        {
            return FALSE;
        }
    }

    //* Get Forums base on cats
    public function getForumByCat($id, $offset)
    {
        $this->db->join('zd_users', 'zd_users.user_id = zd_forums.forum_user_id', 'left');
        $this->db->where('zd_forums.forum_cat_id', $id);
        $this->db->order_by('zd_forums.forum_id', 'DESC');
        $this->db->limit(10, $offset);
        $query = $this->db->get('zd_forums');
        if($query->num_rows() > 0)
        {
            $res = array();
            foreach($query->result() as $fm)
            {
                $res[$fm->forum_id] = $fm;
                $res[$fm->forum_id]->last_reply = $this->getForumLastReplyBoard($fm->forum_id);
                $res[$fm->forum_id]->total_reply = $this->getForumReplyTotalBoard($fm->forum_id);
            }
            return $res;
        }
        else
        {
            return FALSE;
        }
    }

    //* Get top forum topics
    public function getTopForumTopic()
    {
        $this->db->select('*, COUNT(zd_forum_reply.fr_forum_id) AS totreply');
        $this->db->from('zd_forums');
        $this->db->join('zd_users', 'zd_users.user_id = zd_forums.forum_user_id', 'left');
        $this->db->join('zd_forums_cats', 'zd_forums_cats.fcat_id = zd_forums.forum_cat_id', 'left');
        $this->db->join('zd_forum_reply', 'zd_forum_reply.fr_forum_id = zd_forums.forum_id', 'left');
        $this->db->order_by('totreply', 'DESC');
        $this->db->group_by('zd_forums.forum_id');
        $this->db->limit(5);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return FALSE;
        }
    }

    //* Get search forum
    public function getSearch($search, $offset)
    {
        $this->db->join('zd_users', 'zd_users.user_id = zd_forums.forum_user_id', 'left');
        $this->db->like('zd_forums.forum_title', $search);
        $this->db->limit(10, $offset);
        $query = $this->db->get('zd_forums');
        if($query->num_rows() > 0)
        {
            $res = array();
            foreach($query->result() as $fm)
            {
                $res[$fm->forum_id] = $fm;
                $res[$fm->forum_id]->last_reply = $this->getForumLastReplyBoard($fm->forum_id);
                $res[$fm->forum_id]->total_reply = $this->getForumReplyTotalBoard($fm->forum_id);
            }
            return $res;
        }
        else
        {
            return FALSE;
        }
    }

    //* Get forum topics in admin
    public function getForumTopicsInAdmin()
    {
        $this->db->join('zd_users', 'zd_users.user_id = zd_forums.forum_user_id', 'left');
        $this->db->join('zd_forums_cats', 'zd_forums_cats.fcat_id = zd_forums.forum_cat_id', 'left');
        $this->db->order_by('zd_forums.forum_id', 'DESC');
        $query = $this->db->get('zd_forums');
        if($query->num_rows() > 0)
        {
            $res = array();
            foreach($query->result() as $forum)
            {
                $res[$forum->forum_id] = $forum;
                $res[$forum->forum_id]->tot = $this->getTotalReply($forum->forum_id);
            }
            return $res;
        }
        else
        {
            return FALSE;
        }
    }

    //* Get forum by slug in admin
    public function getForumBySlugInAdmin($slug)
    {
        $this->db->join('zd_users', 'zd_users.user_id = zd_forums.forum_user_id', 'left');
        $this->db->join('zd_forums_cats', 'zd_forums_cats.fcat_id = zd_forums.forum_cat_id', 'left');
        $this->db->where('zd_forums.forum_slug', $slug);
        $query = $this->db->get('zd_forums');
        if($query->num_rows() > 0)
        {
            return $query->row(0);
        }
        else
        {
            return FALSE;
        }
    }

    //* Get forum reply by id
    public function getForumReplyById($id)
    {
        $this->db->join('zd_users', 'zd_users.user_id = zd_forum_reply.fr_user_id', 'left');
        $this->db->where('zd_forum_reply.fr_forum_id', $id);
        $this->db->order_by('zd_forum_reply.fr_id', 'DESC');
        $query = $this->db->get('zd_forum_reply');
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return FALSE;
        }
    }

    //* Get reply to edit
    public function getReplToEditByAdmin($id)
    {
        $this->db->where('fr_id', $id);
        $query = $this->db->get('zd_forum_reply');
        if($query->num_rows() > 0)
        {
            return $query->row(0);
        }
    }

    //* Get all forums for sitemap
    public function getAllForumsAvailableOnSite()
    {
        $query = $this->db->get('zd_forums');
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return FALSE;
        }
    }

    /*
    ======================================================
    * REading of data ends
    ======================================================
    */

    /*
    ======================================================
    * Updating of data
    ======================================================
    */

    //* User update forum thrend
    public function updateUserForum($data, $id)
    {
        $this->db->where('forum_id', $id);
        $this->db->update('zd_forums', $data);
        return TRUE;
    }

    //* Update forum reply
    public function updateForumReply($data, $id)
    {
        $this->db->where('	fr_id', $id);
        $this->db->update('zd_forum_reply', $data);
        return TRUE;
    }

    //* Admin update forum topic
    public function updateForumTopic($data, $id)
    {
        $this->db->where('forum_id', $id);
        $this->db->update('zd_forums', $data);
        return TRUE;
    }

    /*
    ======================================================
    * Updating of data ends
    ======================================================
    */

    /*
    ======================================================
    * Deleting of data
    ======================================================
    */

    //* Deleting of forum category
    public function deleteForumCat($id)
    {
        $this->db->where('fcat_id', $id);
        $this->db->delete('zd_forums_cats');
        return TRUE;
    }

    //* Delete forum
    public function deleteForum($id)
    {
        $this->db->where('forum_id', $id);
        $this->db->delete('zd_forums');
        return TRUE;
        
    }

    //* Deleting reply
    public function removeReply($id)
    {
        $this->db->where('fr_id', $id);
        $this->db->delete('zd_forum_reply');
        return TRUE;
    }

    /*
    ======================================================
    * Deleting of data ends
    ======================================================
    */

    /*
    ======================================================
    * Counting of data
    ======================================================
    */

    //* Get forum total reply
    public function getTotalReply($id)
    {
        $this->db->where('fr_forum_id', $id);
        $query = $this->db->get('zd_forum_reply');
        return $query->num_rows();
    }

    //* Get total forum board reply
    public function getForumReplyTotalBoard($id)
    {
        $this->db->where('fr_forum_id', $id);
        $query = $this->db->get('zd_forum_reply');
        return $query->num_rows();
    }

    //* Count total forum by cat slg
    public function getTotalTopicByCatSlug($id)
    {
        $this->db->where('forum_cat_id', $id);
        return $this->db->get('zd_forums')->num_rows();
    }

    //* Get search result count
    public function getTotalSearch($search)
    {
        $this->db->like('forum_title', $search);
        return $this->db->get('zd_forums')->num_rows();
    }

    /*
    ======================================================
    * Conting of data ends
    ======================================================
    */
}